<?php
/* --------------------------------------------------------------
  Utf8Converter.inc.php 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

namespace StyleEdit;

/**
 * Class Utf8Converter
 * 
 * The Utf8Converter is used for template name parameter. On IIS servers it will be latin1 encoded and has to be 
 * converted to utf8.
 * 
 * @package StyleEdit
 */
class Utf8Converter
{
	/**
	 * Performs utf8_encode() if $string parameter contains non-utf8 characters. The utf8-encoded string is returned.
	 * 
	 * @param $string 
	 *
	 * @return string
	 */
	public static function encode($string)
	{
		if(!is_string($string))
		{
			throw new \InvalidArgumentException('$string is not a string ($string: ' . gettype($string) . ')');
		}
		
		if(!preg_match('/(?:[\xC2-\xDF][\x80-\xBF]|\xE0[\xA0-\xBF][\x80-\xBF]|[\xE1-\xEC\xEE\xEF][\x80-\xBF]{2}|\xED[\x80-\x9F][\x80-\xBF]|\xF0[\x90-\xBF][\x80-\xBF]{2}|[\xF1-\xF3][\x80-\xBF]{3}|\xF4[\x80-\x8F][\x80-\xBF]{2})+/xs', $string))
		{
			$string = utf8_encode($string);
		}
		
		return $string;
	}
	
	/**
	 * Basename function wrapper for sanitized filename values.
	 *
	 * @param string $p_filename
	 *
	 * @return string
	 */
	public static function basename($p_filename)
	{
		// backup locale setting
		$locale = setlocale(LC_ALL, 0);
		
		// change locale to multibyte character charset allowing characters like umlauts
		// en_US.UTF8 should always be available
		setlocale(LC_ALL, 'en_US.UTF8');
		
		$basename = basename($p_filename);
		
		// restore locale setting
		setlocale(LC_ALL, $locale);
		
		return $basename;
	}
}